# 字体文件

## 中文字体

由于Chrome扩展的大小限制，默认使用系统字体。如需支持中文PDF生成，请下载并放置以下字体文件：

### 推荐字体

**思源黑体 (Source Han Sans CN)**
- 下载地址: https://github.com/adobe-fonts/source-han-sans/releases
- 文件名: SourceHanSansCN-Regular.otf
- 授权: 开源免费 (SIL Open Font License)

### 字体优化

为减小文件大小，建议：

1. **字体子集化**: 只包含常用汉字
   ```bash
   # 使用fonttools进行字体子集化
   pip install fonttools
   pyftsubset SourceHanSansCN-Regular.otf \
     --text-file=common-chars.txt \
     --output-file=SourceHanSansCN-Regular-subset.otf
   ```

2. **转换为web字体**: 转换为woff2格式
   ```bash
   # 使用woff2工具
   woff2_compress SourceHanSansCN-Regular.otf
   ```

### 备选方案

如果不使用自定义字体，PDF将使用标准字体（Helvetica等），中文字符将显示为拼音或不显示。

### 注意事项

- 完整的思源黑体文件约15-20MB
- 子集化后可减小到2-3MB
- 需要在PDFGenerator.js中配置字体加载路径

